/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.AbortThread;
import com.ibm.hwmca.fw.rbf.impl.CancelReply;
import com.ibm.hwmca.fw.rbf.impl.RbfMsg;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.RequestTrackingData;
import com.ibm.hwmca.fw.rbf.impl.ResultReporter;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashSet;

class CancelMsg
implements RbfMsg {
    private static final String TRACE_MASKT = "XRBFCMST";
    private static final String TRACE_MASKF = "XRBFCMSF";
    private static final String TRACE_MASKD = "XRBFCMSD";
    private static final long serialVersionUID = 6409075352265624581L;
    private RbfRequestId requestId;

    CancelMsg(RbfRequest request) {
        this(request.getIdentifier());
    }

    CancelMsg(RbfRequestId requestId) {
        this.requestId = requestId;
        Trace.trace(TRACE_MASKT, "<> CancelMsg() " + requestId);
    }

    RbfRequestId getRequestId() {
        return this.requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RbfReply process(MachineId sender2, int protocol) {
        RequestTrackingData trackingData;
        Trace.trace(TRACE_MASKT, "-> process()");
        CancelReply reply = new CancelReply(this.requestId);
        RbfRequest request = RbfRequest.getRequest(this.requestId);
        if (request == null) {
            Trace.trace(TRACE_MASKF, "Request no longer managed");
            Trace.trace(TRACE_MASKT, "<- process()");
            return reply;
        }
        RequestTrackingData requestTrackingData = trackingData = request.getTrackingData();
        synchronized (requestTrackingData) {
            if (trackingData.isStateChangeValid(trackingData.state, 12)) {
                trackingData.state = 12;
                trackingData.canceled = true;
                trackingData.addHistory("Canceled at handler " + RbfUtils.getMachineInfo(sender2));
                HashSet<MachineId> toBeAborted = new HashSet<MachineId>();
                if (trackingData.preparing != null) {
                    toBeAborted.addAll(trackingData.preparing);
                    trackingData.preparing.clear();
                }
                if (!trackingData.isHandlerNeeded() && trackingData.handler != null) {
                    toBeAborted.add(trackingData.handler);
                }
                toBeAborted.remove(sender2);
                if (!toBeAborted.isEmpty()) {
                    trackingData.addHistory("Aborting " + RbfUtils.getMachineInfo(toBeAborted));
                    AbortThread at = new AbortThread(request, toBeAborted, 4);
                    at.start();
                }
                ResultReporter.reportAndClose(request, 44, null);
            }
        }
        Trace.trace(TRACE_MASKT, "<- process()");
        return reply;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[CancelMsg: reqId=" + this.requestId + "]");
        return sb.toString();
    }
}

